<?php
require_once __DIR__ . '/vendor/autoload.php';

use Kreait\Firebase\Factory;
use Google\Cloud\Core\Timestamp;
use Google\Cloud\Firestore\FirestoreClient;

class UserCollection
{
    private $firestore;
    private $usersCollection;

    public function __construct(string $serviceAccountPath)
    {
        // Initialize Firebase with Firestore
        $factory = (new Factory)->withServiceAccount($serviceAccountPath);
        $this->firestore = $factory->createFirestore();
        $this->usersCollection = $this->firestore->database()->collection('users');
    }

    /**
     * Update a user document in Firestore
     * 
     * @param string $documentId
     * @param array $data
     * @return bool|string
     */
    public function updateUser(string $documentId, array $data)
    {
        try {
            $documentRef = $this->usersCollection->document($documentId);

            $updateFields = [];
            foreach ($data as $key => $value) {
                $updateFields[] = ['path' => $key, 'value' => $value];
            }

            $updateFields[] = ['path' => 'updatedAt', 'value' => new Timestamp(new \DateTime())];

            $documentRef->update($updateFields);

            return true;
        } catch (\Exception $e) {
            return "Error: " . $e->getMessage();
        }
    }
}
