<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require __DIR__ . '/Razorpay0/Razorpay.php';   // load SDK


use Razorpay\Api\Api;

header('Content-Type: application/json');
 
// Your Razorpay credentials
$keyId = "rzp_live_RFNrVJa7XIQtOK";
$keySecret = "W8NGFxZYfm0aStJYFKBsytFj";          // Secret key (keep private!)

$api = new Api($keyId, $keySecret);

// Read JSON from request
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['amount']) || !isset($data['currency'])) {
    echo json_encode(["error" => "amount and currency are required"]);
    http_response_code(400);
    exit;
}

try {
    // Create order on Razorpay
    $order = $api->order->create([
        'receipt'  => $data['receipt'] ?? 'order_rcptid_' . time(),
        'amount'   => $data['amount'],   // in paise
        'currency' => $data['currency'], // INR
        'notes'    => [
            "uid" => $data['uid'] ?? "guest"
        ]
    ]);

    echo json_encode($order->toArray());
} catch (Exception $e) { 
    echo json_encode([
        "error" => $e->getMessage()
    ]);
}
